import { wayfinder } from '@laravel/vite-plugin-wayfinder';
import tailwindcss from '@tailwindcss/vite';
import react from '@vitejs/plugin-react';
import laravel from 'laravel-vite-plugin';
import { defineConfig } from 'vite';

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.tsx'],
            ssr: 'resources/js/ssr.tsx',
            refresh: true,
        }),
        react({
            babel: {
                plugins: ['babel-plugin-react-compiler'],
            },
        }),
        tailwindcss(),
        wayfinder({
            formVariants: true,
        }),
    ],
    esbuild: {
        jsx: 'automatic',
    },
    /**
     * Workaround for a crash in `laravel-vite-plugin@2.0.0` where
     * `server.httpServer.address()` may be `null` during restart, causing:
     * "TypeError: Cannot read properties of null (reading 'family')".
     *
     * By setting an explicit origin/host/port, the plugin avoids the auto
     * dev-server URL resolution path.
     */
    server: {
        host: '127.0.0.1',
        port: 5173,
        strictPort: true,
        origin: 'http://127.0.0.1:5173',
        // Important: if `server.origin` is set, the Laravel Vite plugin defaults
        // CORS to that origin only. We must explicitly allow the Laravel app origin.
        cors: {
            origin: [
                // Laravel (dev)
                /^https?:\/\/localhost(?::\d+)?$/,
                /^https?:\/\/127\.0\.0\.1(?::\d+)?$/,
                // optional IPv6 loopback
                /^https?:\/\/\[::1\](?::\d+)?$/,
            ],
        },
    },
});
