<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Additional attributes associated with the use of a Venmo Wallet.
 */
class VenmoWalletAttributesResponse implements \JsonSerializable
{
    /**
     * @var VenmoVaultResponse|null
     */
    private $vault;

    /**
     * Returns Vault.
     * The details about a saved venmo payment source.
     */
    public function getVault(): ?VenmoVaultResponse
    {
        return $this->vault;
    }

    /**
     * Sets Vault.
     * The details about a saved venmo payment source.
     *
     * @maps vault
     */
    public function setVault(?VenmoVaultResponse $vault): void
    {
        $this->vault = $vault;
    }

    /**
     * Converts the VenmoWalletAttributesResponse object to a human-readable string representation.
     *
     * @return string The string representation of the VenmoWalletAttributesResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('VenmoWalletAttributesResponse', ['vault' => $this->vault]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->vault)) {
            $json['vault'] = $this->vault;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
