<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * A resource representing a request to vault Apple Pay.
 */
class VaultApplePayRequest implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $token;

    /**
     * @var ApplePayRequestCard|null
     */
    private $card;

    /**
     * Returns Token.
     * Encrypted Apple Pay token, containing card information. This token would be base64 encoded.
     */
    public function getToken(): ?string
    {
        return $this->token;
    }

    /**
     * Sets Token.
     * Encrypted Apple Pay token, containing card information. This token would be base64 encoded.
     *
     * @maps token
     */
    public function setToken(?string $token): void
    {
        $this->token = $token;
    }

    /**
     * Returns Card.
     * The payment card to be used to fund a payment. Can be a credit or debit card.
     */
    public function getCard(): ?ApplePayRequestCard
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * The payment card to be used to fund a payment. Can be a credit or debit card.
     *
     * @maps card
     */
    public function setCard(?ApplePayRequestCard $card): void
    {
        $this->card = $card;
    }

    /**
     * Converts the VaultApplePayRequest object to a human-readable string representation.
     *
     * @return string The string representation of the VaultApplePayRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('VaultApplePayRequest', ['token' => $this->token, 'card' => $this->card]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->token)) {
            $json['token'] = $this->token;
        }
        if (isset($this->card)) {
            $json['card']  = $this->card;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
