<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The list transactions for a subscription request details.
 */
class TransactionsList implements \JsonSerializable
{
    /**
     * @var SubscriptionTransactionDetails[]|null
     */
    private $transactions;

    /**
     * @var int|null
     */
    private $totalItems;

    /**
     * @var int|null
     */
    private $totalPages;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Transactions.
     * An array of transactions.
     *
     * @return SubscriptionTransactionDetails[]|null
     */
    public function getTransactions(): ?array
    {
        return $this->transactions;
    }

    /**
     * Sets Transactions.
     * An array of transactions.
     *
     * @maps transactions
     *
     * @param SubscriptionTransactionDetails[]|null $transactions
     */
    public function setTransactions(?array $transactions): void
    {
        $this->transactions = $transactions;
    }

    /**
     * Returns Total Items.
     * The total number of items.
     */
    public function getTotalItems(): ?int
    {
        return $this->totalItems;
    }

    /**
     * Sets Total Items.
     * The total number of items.
     *
     * @maps total_items
     */
    public function setTotalItems(?int $totalItems): void
    {
        $this->totalItems = $totalItems;
    }

    /**
     * Returns Total Pages.
     * The total number of pages.
     */
    public function getTotalPages(): ?int
    {
        return $this->totalPages;
    }

    /**
     * Sets Total Pages.
     * The total number of pages.
     *
     * @maps total_pages
     */
    public function setTotalPages(?int $totalPages): void
    {
        $this->totalPages = $totalPages;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the TransactionsList object to a human-readable string representation.
     *
     * @return string The string representation of the TransactionsList object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'TransactionsList',
            [
                'transactions' => $this->transactions,
                'totalItems' => $this->totalItems,
                'totalPages' => $this->totalPages,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->transactions)) {
            $json['transactions'] = $this->transactions;
        }
        if (isset($this->totalItems)) {
            $json['total_items']  = $this->totalItems;
        }
        if (isset($this->totalPages)) {
            $json['total_pages']  = $this->totalPages;
        }
        if (isset($this->links)) {
            $json['links']        = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
