<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The transaction information.
 */
class TransactionInformation implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $paypalAccountId;

    /**
     * @var string|null
     */
    private $transactionId;

    /**
     * @var string|null
     */
    private $paypalReferenceId;

    /**
     * @var string|null
     */
    private $paypalReferenceIdType;

    /**
     * @var string|null
     */
    private $transactionEventCode;

    /**
     * @var string|null
     */
    private $transactionInitiationDate;

    /**
     * @var string|null
     */
    private $transactionUpdatedDate;

    /**
     * @var Money|null
     */
    private $transactionAmount;

    /**
     * @var Money|null
     */
    private $feeAmount;

    /**
     * @var Money|null
     */
    private $discountAmount;

    /**
     * @var Money|null
     */
    private $insuranceAmount;

    /**
     * @var Money|null
     */
    private $salesTaxAmount;

    /**
     * @var Money|null
     */
    private $shippingAmount;

    /**
     * @var Money|null
     */
    private $shippingDiscountAmount;

    /**
     * @var Money|null
     */
    private $shippingTaxAmount;

    /**
     * @var Money|null
     */
    private $otherAmount;

    /**
     * @var Money|null
     */
    private $tipAmount;

    /**
     * @var string|null
     */
    private $transactionStatus;

    /**
     * @var string|null
     */
    private $transactionSubject;

    /**
     * @var string|null
     */
    private $transactionNote;

    /**
     * @var string|null
     */
    private $paymentTrackingId;

    /**
     * @var string|null
     */
    private $bankReferenceId;

    /**
     * @var Money|null
     */
    private $endingBalance;

    /**
     * @var Money|null
     */
    private $availableBalance;

    /**
     * @var string|null
     */
    private $invoiceId;

    /**
     * @var string|null
     */
    private $customField;

    /**
     * @var string|null
     */
    private $protectionEligibility;

    /**
     * @var string|null
     */
    private $creditTerm;

    /**
     * @var Money|null
     */
    private $creditTransactionalFee;

    /**
     * @var Money|null
     */
    private $creditPromotionalFee;

    /**
     * @var string|null
     */
    private $annualPercentageRate;

    /**
     * @var string|null
     */
    private $paymentMethodType;

    /**
     * @var string|null
     */
    private $instrumentType;

    /**
     * @var string|null
     */
    private $instrumentSubType;

    /**
     * Returns Paypal Account Id.
     * The ID of the PayPal account of the counterparty.
     */
    public function getPaypalAccountId(): ?string
    {
        return $this->paypalAccountId;
    }

    /**
     * Sets Paypal Account Id.
     * The ID of the PayPal account of the counterparty.
     *
     * @maps paypal_account_id
     */
    public function setPaypalAccountId(?string $paypalAccountId): void
    {
        $this->paypalAccountId = $paypalAccountId;
    }

    /**
     * Returns Transaction Id.
     * The PayPal-generated transaction ID.
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * Sets Transaction Id.
     * The PayPal-generated transaction ID.
     *
     * @maps transaction_id
     */
    public function setTransactionId(?string $transactionId): void
    {
        $this->transactionId = $transactionId;
    }

    /**
     * Returns Paypal Reference Id.
     * The PayPal-generated base ID. PayPal exclusive. Cannot be altered. Defined as a related, pre-
     * existing transaction or event.
     */
    public function getPaypalReferenceId(): ?string
    {
        return $this->paypalReferenceId;
    }

    /**
     * Sets Paypal Reference Id.
     * The PayPal-generated base ID. PayPal exclusive. Cannot be altered. Defined as a related, pre-
     * existing transaction or event.
     *
     * @maps paypal_reference_id
     */
    public function setPaypalReferenceId(?string $paypalReferenceId): void
    {
        $this->paypalReferenceId = $paypalReferenceId;
    }

    /**
     * Returns Paypal Reference Id Type.
     * The PayPal reference ID type.
     */
    public function getPaypalReferenceIdType(): ?string
    {
        return $this->paypalReferenceIdType;
    }

    /**
     * Sets Paypal Reference Id Type.
     * The PayPal reference ID type.
     *
     * @maps paypal_reference_id_type
     */
    public function setPaypalReferenceIdType(?string $paypalReferenceIdType): void
    {
        $this->paypalReferenceIdType = $paypalReferenceIdType;
    }

    /**
     * Returns Transaction Event Code.
     * A five-digit transaction event code that classifies the transaction type based on money movement and
     * debit or credit. For example, T0001. See [Transaction event
     * codes](/docs/integration/direct/transaction-search/transaction-event-codes/).
     */
    public function getTransactionEventCode(): ?string
    {
        return $this->transactionEventCode;
    }

    /**
     * Sets Transaction Event Code.
     * A five-digit transaction event code that classifies the transaction type based on money movement and
     * debit or credit. For example, T0001. See [Transaction event
     * codes](/docs/integration/direct/transaction-search/transaction-event-codes/).
     *
     * @maps transaction_event_code
     */
    public function setTransactionEventCode(?string $transactionEventCode): void
    {
        $this->transactionEventCode = $transactionEventCode;
    }

    /**
     * Returns Transaction Initiation Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getTransactionInitiationDate(): ?string
    {
        return $this->transactionInitiationDate;
    }

    /**
     * Sets Transaction Initiation Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps transaction_initiation_date
     */
    public function setTransactionInitiationDate(?string $transactionInitiationDate): void
    {
        $this->transactionInitiationDate = $transactionInitiationDate;
    }

    /**
     * Returns Transaction Updated Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getTransactionUpdatedDate(): ?string
    {
        return $this->transactionUpdatedDate;
    }

    /**
     * Sets Transaction Updated Date.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps transaction_updated_date
     */
    public function setTransactionUpdatedDate(?string $transactionUpdatedDate): void
    {
        $this->transactionUpdatedDate = $transactionUpdatedDate;
    }

    /**
     * Returns Transaction Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTransactionAmount(): ?Money
    {
        return $this->transactionAmount;
    }

    /**
     * Sets Transaction Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps transaction_amount
     */
    public function setTransactionAmount(?Money $transactionAmount): void
    {
        $this->transactionAmount = $transactionAmount;
    }

    /**
     * Returns Fee Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getFeeAmount(): ?Money
    {
        return $this->feeAmount;
    }

    /**
     * Sets Fee Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps fee_amount
     */
    public function setFeeAmount(?Money $feeAmount): void
    {
        $this->feeAmount = $feeAmount;
    }

    /**
     * Returns Discount Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getDiscountAmount(): ?Money
    {
        return $this->discountAmount;
    }

    /**
     * Sets Discount Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps discount_amount
     */
    public function setDiscountAmount(?Money $discountAmount): void
    {
        $this->discountAmount = $discountAmount;
    }

    /**
     * Returns Insurance Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getInsuranceAmount(): ?Money
    {
        return $this->insuranceAmount;
    }

    /**
     * Sets Insurance Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps insurance_amount
     */
    public function setInsuranceAmount(?Money $insuranceAmount): void
    {
        $this->insuranceAmount = $insuranceAmount;
    }

    /**
     * Returns Sales Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getSalesTaxAmount(): ?Money
    {
        return $this->salesTaxAmount;
    }

    /**
     * Sets Sales Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps sales_tax_amount
     */
    public function setSalesTaxAmount(?Money $salesTaxAmount): void
    {
        $this->salesTaxAmount = $salesTaxAmount;
    }

    /**
     * Returns Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingAmount(): ?Money
    {
        return $this->shippingAmount;
    }

    /**
     * Sets Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_amount
     */
    public function setShippingAmount(?Money $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }

    /**
     * Returns Shipping Discount Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingDiscountAmount(): ?Money
    {
        return $this->shippingDiscountAmount;
    }

    /**
     * Sets Shipping Discount Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_discount_amount
     */
    public function setShippingDiscountAmount(?Money $shippingDiscountAmount): void
    {
        $this->shippingDiscountAmount = $shippingDiscountAmount;
    }

    /**
     * Returns Shipping Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingTaxAmount(): ?Money
    {
        return $this->shippingTaxAmount;
    }

    /**
     * Sets Shipping Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_tax_amount
     */
    public function setShippingTaxAmount(?Money $shippingTaxAmount): void
    {
        $this->shippingTaxAmount = $shippingTaxAmount;
    }

    /**
     * Returns Other Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getOtherAmount(): ?Money
    {
        return $this->otherAmount;
    }

    /**
     * Sets Other Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps other_amount
     */
    public function setOtherAmount(?Money $otherAmount): void
    {
        $this->otherAmount = $otherAmount;
    }

    /**
     * Returns Tip Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTipAmount(): ?Money
    {
        return $this->tipAmount;
    }

    /**
     * Sets Tip Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps tip_amount
     */
    public function setTipAmount(?Money $tipAmount): void
    {
        $this->tipAmount = $tipAmount;
    }

    /**
     * Returns Transaction Status.
     * A code that indicates the transaction status. Value is: Status code Description D PayPal or merchant
     * rules denied the transaction. P The transaction is pending. The transaction was created but waits
     * for another payment process to complete, such as an ACH transaction, before the status changes to S.
     * S The transaction successfully completed without a denial and after any pending statuses. V A
     * successful transaction was fully reversed and funds were refunded to the original sender.
     */
    public function getTransactionStatus(): ?string
    {
        return $this->transactionStatus;
    }

    /**
     * Sets Transaction Status.
     * A code that indicates the transaction status. Value is: Status code Description D PayPal or merchant
     * rules denied the transaction. P The transaction is pending. The transaction was created but waits
     * for another payment process to complete, such as an ACH transaction, before the status changes to S.
     * S The transaction successfully completed without a denial and after any pending statuses. V A
     * successful transaction was fully reversed and funds were refunded to the original sender.
     *
     * @maps transaction_status
     */
    public function setTransactionStatus(?string $transactionStatus): void
    {
        $this->transactionStatus = $transactionStatus;
    }

    /**
     * Returns Transaction Subject.
     * The subject of payment. The payer passes this value to the payee. The payer controls this data
     * through the interface through which he or she sends the data.
     */
    public function getTransactionSubject(): ?string
    {
        return $this->transactionSubject;
    }

    /**
     * Sets Transaction Subject.
     * The subject of payment. The payer passes this value to the payee. The payer controls this data
     * through the interface through which he or she sends the data.
     *
     * @maps transaction_subject
     */
    public function setTransactionSubject(?string $transactionSubject): void
    {
        $this->transactionSubject = $transactionSubject;
    }

    /**
     * Returns Transaction Note.
     * A special note that the payer passes to the payee. Might contain special customer requests, such as
     * shipping instructions.
     */
    public function getTransactionNote(): ?string
    {
        return $this->transactionNote;
    }

    /**
     * Sets Transaction Note.
     * A special note that the payer passes to the payee. Might contain special customer requests, such as
     * shipping instructions.
     *
     * @maps transaction_note
     */
    public function setTransactionNote(?string $transactionNote): void
    {
        $this->transactionNote = $transactionNote;
    }

    /**
     * Returns Payment Tracking Id.
     * The payment tracking ID, which is a unique ID that partners specify to either get information about
     * a payment or request a refund.
     */
    public function getPaymentTrackingId(): ?string
    {
        return $this->paymentTrackingId;
    }

    /**
     * Sets Payment Tracking Id.
     * The payment tracking ID, which is a unique ID that partners specify to either get information about
     * a payment or request a refund.
     *
     * @maps payment_tracking_id
     */
    public function setPaymentTrackingId(?string $paymentTrackingId): void
    {
        $this->paymentTrackingId = $paymentTrackingId;
    }

    /**
     * Returns Bank Reference Id.
     * The bank reference ID. The bank provides this value for an ACH transaction.
     */
    public function getBankReferenceId(): ?string
    {
        return $this->bankReferenceId;
    }

    /**
     * Sets Bank Reference Id.
     * The bank reference ID. The bank provides this value for an ACH transaction.
     *
     * @maps bank_reference_id
     */
    public function setBankReferenceId(?string $bankReferenceId): void
    {
        $this->bankReferenceId = $bankReferenceId;
    }

    /**
     * Returns Ending Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getEndingBalance(): ?Money
    {
        return $this->endingBalance;
    }

    /**
     * Sets Ending Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps ending_balance
     */
    public function setEndingBalance(?Money $endingBalance): void
    {
        $this->endingBalance = $endingBalance;
    }

    /**
     * Returns Available Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAvailableBalance(): ?Money
    {
        return $this->availableBalance;
    }

    /**
     * Sets Available Balance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps available_balance
     */
    public function setAvailableBalance(?Money $availableBalance): void
    {
        $this->availableBalance = $availableBalance;
    }

    /**
     * Returns Invoice Id.
     * The invoice ID that is sent by the merchant with the transaction. Note: If an invoice ID was sent
     * with the capture request, the value is reported. Otherwise, the invoice ID of the authorizing
     * transaction is reported.
     */
    public function getInvoiceId(): ?string
    {
        return $this->invoiceId;
    }

    /**
     * Sets Invoice Id.
     * The invoice ID that is sent by the merchant with the transaction. Note: If an invoice ID was sent
     * with the capture request, the value is reported. Otherwise, the invoice ID of the authorizing
     * transaction is reported.
     *
     * @maps invoice_id
     */
    public function setInvoiceId(?string $invoiceId): void
    {
        $this->invoiceId = $invoiceId;
    }

    /**
     * Returns Custom Field.
     * The merchant-provided custom text. Note: Usually, this field includes the unique ID for payments
     * made with MassPay type transaction.
     */
    public function getCustomField(): ?string
    {
        return $this->customField;
    }

    /**
     * Sets Custom Field.
     * The merchant-provided custom text. Note: Usually, this field includes the unique ID for payments
     * made with MassPay type transaction.
     *
     * @maps custom_field
     */
    public function setCustomField(?string $customField): void
    {
        $this->customField = $customField;
    }

    /**
     * Returns Protection Eligibility.
     * Indicates whether the transaction is eligible for protection. Value is: 01. Eligible. 02. Not
     * eligible 03. Partially eligible.
     */
    public function getProtectionEligibility(): ?string
    {
        return $this->protectionEligibility;
    }

    /**
     * Sets Protection Eligibility.
     * Indicates whether the transaction is eligible for protection. Value is: 01. Eligible. 02. Not
     * eligible 03. Partially eligible.
     *
     * @maps protection_eligibility
     */
    public function setProtectionEligibility(?string $protectionEligibility): void
    {
        $this->protectionEligibility = $protectionEligibility;
    }

    /**
     * Returns Credit Term.
     * The credit term. The time span covered by the installment payments as expressed in the term length
     * plus the length time unit code.
     */
    public function getCreditTerm(): ?string
    {
        return $this->creditTerm;
    }

    /**
     * Sets Credit Term.
     * The credit term. The time span covered by the installment payments as expressed in the term length
     * plus the length time unit code.
     *
     * @maps credit_term
     */
    public function setCreditTerm(?string $creditTerm): void
    {
        $this->creditTerm = $creditTerm;
    }

    /**
     * Returns Credit Transactional Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getCreditTransactionalFee(): ?Money
    {
        return $this->creditTransactionalFee;
    }

    /**
     * Sets Credit Transactional Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps credit_transactional_fee
     */
    public function setCreditTransactionalFee(?Money $creditTransactionalFee): void
    {
        $this->creditTransactionalFee = $creditTransactionalFee;
    }

    /**
     * Returns Credit Promotional Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getCreditPromotionalFee(): ?Money
    {
        return $this->creditPromotionalFee;
    }

    /**
     * Sets Credit Promotional Fee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps credit_promotional_fee
     */
    public function setCreditPromotionalFee(?Money $creditPromotionalFee): void
    {
        $this->creditPromotionalFee = $creditPromotionalFee;
    }

    /**
     * Returns Annual Percentage Rate.
     * The percentage, as a fixed-point, signed decimal number. For example, define a 19.99% interest rate
     * as `19.99`.
     */
    public function getAnnualPercentageRate(): ?string
    {
        return $this->annualPercentageRate;
    }

    /**
     * Sets Annual Percentage Rate.
     * The percentage, as a fixed-point, signed decimal number. For example, define a 19.99% interest rate
     * as `19.99`.
     *
     * @maps annual_percentage_rate
     */
    public function setAnnualPercentageRate(?string $annualPercentageRate): void
    {
        $this->annualPercentageRate = $annualPercentageRate;
    }

    /**
     * Returns Payment Method Type.
     * The payment method that was used for a transaction. Value is PUI, installment, or mEFT. Note:
     * Appears only for pay upon invoice (PUI), installment, and mEFT transactions. Merchants and partners
     * in the EMEA region can use this attribute to note transactions that attract turn-over tax.
     */
    public function getPaymentMethodType(): ?string
    {
        return $this->paymentMethodType;
    }

    /**
     * Sets Payment Method Type.
     * The payment method that was used for a transaction. Value is PUI, installment, or mEFT. Note:
     * Appears only for pay upon invoice (PUI), installment, and mEFT transactions. Merchants and partners
     * in the EMEA region can use this attribute to note transactions that attract turn-over tax.
     *
     * @maps payment_method_type
     */
    public function setPaymentMethodType(?string $paymentMethodType): void
    {
        $this->paymentMethodType = $paymentMethodType;
    }

    /**
     * Returns Instrument Type.
     * A high-level classification of the type of financial instrument that was used to fund a payment. The
     * pattern is not provided because the value is defined by an external party. E.g. PAYPAL, CREDIT_CARD,
     * DEBIT_CARD, APPLE_PAY, BANK , VENMO ,Pay Upon Invoice, Pay Later  or Alternative Payment Methods
     * (APM).
     */
    public function getInstrumentType(): ?string
    {
        return $this->instrumentType;
    }

    /**
     * Sets Instrument Type.
     * A high-level classification of the type of financial instrument that was used to fund a payment. The
     * pattern is not provided because the value is defined by an external party. E.g. PAYPAL, CREDIT_CARD,
     * DEBIT_CARD, APPLE_PAY, BANK , VENMO ,Pay Upon Invoice, Pay Later  or Alternative Payment Methods
     * (APM).
     *
     * @maps instrument_type
     */
    public function setInstrumentType(?string $instrumentType): void
    {
        $this->instrumentType = $instrumentType;
    }

    /**
     * Returns Instrument Sub Type.
     * A finer-grained classification of the financial instrument that was used to fund a payment. For
     * example, `Visa card` or a `Mastercard` for a credit card, BANKCARD ,DISCOVER etc. The pattern is not
     * provided because the value is defined by an external party.
     */
    public function getInstrumentSubType(): ?string
    {
        return $this->instrumentSubType;
    }

    /**
     * Sets Instrument Sub Type.
     * A finer-grained classification of the financial instrument that was used to fund a payment. For
     * example, `Visa card` or a `Mastercard` for a credit card, BANKCARD ,DISCOVER etc. The pattern is not
     * provided because the value is defined by an external party.
     *
     * @maps instrument_sub_type
     */
    public function setInstrumentSubType(?string $instrumentSubType): void
    {
        $this->instrumentSubType = $instrumentSubType;
    }

    /**
     * Converts the TransactionInformation object to a human-readable string representation.
     *
     * @return string The string representation of the TransactionInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'TransactionInformation',
            [
                'paypalAccountId' => $this->paypalAccountId,
                'transactionId' => $this->transactionId,
                'paypalReferenceId' => $this->paypalReferenceId,
                'paypalReferenceIdType' => $this->paypalReferenceIdType,
                'transactionEventCode' => $this->transactionEventCode,
                'transactionInitiationDate' => $this->transactionInitiationDate,
                'transactionUpdatedDate' => $this->transactionUpdatedDate,
                'transactionAmount' => $this->transactionAmount,
                'feeAmount' => $this->feeAmount,
                'discountAmount' => $this->discountAmount,
                'insuranceAmount' => $this->insuranceAmount,
                'salesTaxAmount' => $this->salesTaxAmount,
                'shippingAmount' => $this->shippingAmount,
                'shippingDiscountAmount' => $this->shippingDiscountAmount,
                'shippingTaxAmount' => $this->shippingTaxAmount,
                'otherAmount' => $this->otherAmount,
                'tipAmount' => $this->tipAmount,
                'transactionStatus' => $this->transactionStatus,
                'transactionSubject' => $this->transactionSubject,
                'transactionNote' => $this->transactionNote,
                'paymentTrackingId' => $this->paymentTrackingId,
                'bankReferenceId' => $this->bankReferenceId,
                'endingBalance' => $this->endingBalance,
                'availableBalance' => $this->availableBalance,
                'invoiceId' => $this->invoiceId,
                'customField' => $this->customField,
                'protectionEligibility' => $this->protectionEligibility,
                'creditTerm' => $this->creditTerm,
                'creditTransactionalFee' => $this->creditTransactionalFee,
                'creditPromotionalFee' => $this->creditPromotionalFee,
                'annualPercentageRate' => $this->annualPercentageRate,
                'paymentMethodType' => $this->paymentMethodType,
                'instrumentType' => $this->instrumentType,
                'instrumentSubType' => $this->instrumentSubType
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->paypalAccountId)) {
            $json['paypal_account_id']           = $this->paypalAccountId;
        }
        if (isset($this->transactionId)) {
            $json['transaction_id']              = $this->transactionId;
        }
        if (isset($this->paypalReferenceId)) {
            $json['paypal_reference_id']         = $this->paypalReferenceId;
        }
        if (isset($this->paypalReferenceIdType)) {
            $json['paypal_reference_id_type']    = $this->paypalReferenceIdType;
        }
        if (isset($this->transactionEventCode)) {
            $json['transaction_event_code']      = $this->transactionEventCode;
        }
        if (isset($this->transactionInitiationDate)) {
            $json['transaction_initiation_date'] = $this->transactionInitiationDate;
        }
        if (isset($this->transactionUpdatedDate)) {
            $json['transaction_updated_date']    = $this->transactionUpdatedDate;
        }
        if (isset($this->transactionAmount)) {
            $json['transaction_amount']          = $this->transactionAmount;
        }
        if (isset($this->feeAmount)) {
            $json['fee_amount']                  = $this->feeAmount;
        }
        if (isset($this->discountAmount)) {
            $json['discount_amount']             = $this->discountAmount;
        }
        if (isset($this->insuranceAmount)) {
            $json['insurance_amount']            = $this->insuranceAmount;
        }
        if (isset($this->salesTaxAmount)) {
            $json['sales_tax_amount']            = $this->salesTaxAmount;
        }
        if (isset($this->shippingAmount)) {
            $json['shipping_amount']             = $this->shippingAmount;
        }
        if (isset($this->shippingDiscountAmount)) {
            $json['shipping_discount_amount']    = $this->shippingDiscountAmount;
        }
        if (isset($this->shippingTaxAmount)) {
            $json['shipping_tax_amount']         = $this->shippingTaxAmount;
        }
        if (isset($this->otherAmount)) {
            $json['other_amount']                = $this->otherAmount;
        }
        if (isset($this->tipAmount)) {
            $json['tip_amount']                  = $this->tipAmount;
        }
        if (isset($this->transactionStatus)) {
            $json['transaction_status']          = $this->transactionStatus;
        }
        if (isset($this->transactionSubject)) {
            $json['transaction_subject']         = $this->transactionSubject;
        }
        if (isset($this->transactionNote)) {
            $json['transaction_note']            = $this->transactionNote;
        }
        if (isset($this->paymentTrackingId)) {
            $json['payment_tracking_id']         = $this->paymentTrackingId;
        }
        if (isset($this->bankReferenceId)) {
            $json['bank_reference_id']           = $this->bankReferenceId;
        }
        if (isset($this->endingBalance)) {
            $json['ending_balance']              = $this->endingBalance;
        }
        if (isset($this->availableBalance)) {
            $json['available_balance']           = $this->availableBalance;
        }
        if (isset($this->invoiceId)) {
            $json['invoice_id']                  = $this->invoiceId;
        }
        if (isset($this->customField)) {
            $json['custom_field']                = $this->customField;
        }
        if (isset($this->protectionEligibility)) {
            $json['protection_eligibility']      = $this->protectionEligibility;
        }
        if (isset($this->creditTerm)) {
            $json['credit_term']                 = $this->creditTerm;
        }
        if (isset($this->creditTransactionalFee)) {
            $json['credit_transactional_fee']    = $this->creditTransactionalFee;
        }
        if (isset($this->creditPromotionalFee)) {
            $json['credit_promotional_fee']      = $this->creditPromotionalFee;
        }
        if (isset($this->annualPercentageRate)) {
            $json['annual_percentage_rate']      = $this->annualPercentageRate;
        }
        if (isset($this->paymentMethodType)) {
            $json['payment_method_type']         = $this->paymentMethodType;
        }
        if (isset($this->instrumentType)) {
            $json['instrument_type']             = $this->instrumentType;
        }
        if (isset($this->instrumentSubType)) {
            $json['instrument_sub_type']         = $this->instrumentSubType;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
