<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The tax details.
 */
class TaxesOverride implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $percentage;

    /**
     * @var bool|null
     */
    private $inclusive;

    /**
     * Returns Percentage.
     * The percentage, as a fixed-point, signed decimal number. For example, define a 19.99% interest rate
     * as `19.99`.
     */
    public function getPercentage(): ?string
    {
        return $this->percentage;
    }

    /**
     * Sets Percentage.
     * The percentage, as a fixed-point, signed decimal number. For example, define a 19.99% interest rate
     * as `19.99`.
     *
     * @maps percentage
     */
    public function setPercentage(?string $percentage): void
    {
        $this->percentage = $percentage;
    }

    /**
     * Returns Inclusive.
     * Indicates whether the tax was already included in the billing amount.
     */
    public function getInclusive(): ?bool
    {
        return $this->inclusive;
    }

    /**
     * Sets Inclusive.
     * Indicates whether the tax was already included in the billing amount.
     *
     * @maps inclusive
     */
    public function setInclusive(?bool $inclusive): void
    {
        $this->inclusive = $inclusive;
    }

    /**
     * Converts the TaxesOverride object to a human-readable string representation.
     *
     * @return string The string representation of the TaxesOverride object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'TaxesOverride',
            ['percentage' => $this->percentage, 'inclusive' => $this->inclusive]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->percentage)) {
            $json['percentage'] = $this->percentage;
        }
        if (isset($this->inclusive)) {
            $json['inclusive']  = $this->inclusive;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
