<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The tax levied by a government on the purchase of goods or services.
 */
class TaxAmount implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $taxAmount;

    /**
     * Returns Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTaxAmount(): ?Money
    {
        return $this->taxAmount;
    }

    /**
     * Sets Tax Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps tax_amount
     */
    public function setTaxAmount(?Money $taxAmount): void
    {
        $this->taxAmount = $taxAmount;
    }

    /**
     * Converts the TaxAmount object to a human-readable string representation.
     *
     * @return string The string representation of the TaxAmount object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('TaxAmount', ['taxAmount' => $this->taxAmount]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->taxAmount)) {
            $json['tax_amount'] = $this->taxAmount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
