<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The payment source used to fund the payment.
 */
class SubscriptionPaymentSourceResponse implements \JsonSerializable
{
    /**
     * @var CardResponseWithBillingAddress|null
     */
    private $card;

    /**
     * Returns Card.
     * The payment card used to fund the payment. Card can be a credit or debit card.
     */
    public function getCard(): ?CardResponseWithBillingAddress
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * The payment card used to fund the payment. Card can be a credit or debit card.
     *
     * @maps card
     */
    public function setCard(?CardResponseWithBillingAddress $card): void
    {
        $this->card = $card;
    }

    /**
     * Converts the SubscriptionPaymentSourceResponse object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionPaymentSourceResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('SubscriptionPaymentSourceResponse', ['card' => $this->card]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card'] = $this->card;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
