<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The subscriber response information.
 */
class Subscriber implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $emailAddress;

    /**
     * @var string|null
     */
    private $payerId;

    /**
     * @var Name|null
     */
    private $name;

    /**
     * @var ShippingDetails|null
     */
    private $shippingAddress;

    /**
     * @var SubscriptionPaymentSourceResponse|null
     */
    private $paymentSource;

    /**
     * Returns Email Address.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     */
    public function getEmailAddress(): ?string
    {
        return $this->emailAddress;
    }

    /**
     * Sets Email Address.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     *
     * @maps email_address
     */
    public function setEmailAddress(?string $emailAddress): void
    {
        $this->emailAddress = $emailAddress;
    }

    /**
     * Returns Payer Id.
     * The account identifier for a PayPal account.
     */
    public function getPayerId(): ?string
    {
        return $this->payerId;
    }

    /**
     * Sets Payer Id.
     * The account identifier for a PayPal account.
     *
     * @maps payer_id
     */
    public function setPayerId(?string $payerId): void
    {
        $this->payerId = $payerId;
    }

    /**
     * Returns Name.
     * The name of the party.
     */
    public function getName(): ?Name
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The name of the party.
     *
     * @maps name
     */
    public function setName(?Name $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Shipping Address.
     * The shipping details.
     */
    public function getShippingAddress(): ?ShippingDetails
    {
        return $this->shippingAddress;
    }

    /**
     * Sets Shipping Address.
     * The shipping details.
     *
     * @maps shipping_address
     */
    public function setShippingAddress(?ShippingDetails $shippingAddress): void
    {
        $this->shippingAddress = $shippingAddress;
    }

    /**
     * Returns Payment Source.
     * The payment source used to fund the payment.
     */
    public function getPaymentSource(): ?SubscriptionPaymentSourceResponse
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The payment source used to fund the payment.
     *
     * @maps payment_source
     */
    public function setPaymentSource(?SubscriptionPaymentSourceResponse $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Converts the Subscriber object to a human-readable string representation.
     *
     * @return string The string representation of the Subscriber object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'Subscriber',
            [
                'emailAddress' => $this->emailAddress,
                'payerId' => $this->payerId,
                'name' => $this->name,
                'shippingAddress' => $this->shippingAddress,
                'paymentSource' => $this->paymentSource
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->emailAddress)) {
            $json['email_address']    = $this->emailAddress;
        }
        if (isset($this->payerId)) {
            $json['payer_id']         = $this->payerId;
        }
        if (isset($this->name)) {
            $json['name']             = $this->name;
        }
        if (isset($this->shippingAddress)) {
            $json['shipping_address'] = $this->shippingAddress;
        }
        if (isset($this->paymentSource)) {
            $json['payment_source']   = $this->paymentSource;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
