<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The name of the party.
 */
class ShippingName implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $fullName;

    /**
     * Returns Full Name.
     * When the party is a person, the party's full name.
     */
    public function getFullName(): ?string
    {
        return $this->fullName;
    }

    /**
     * Sets Full Name.
     * When the party is a person, the party's full name.
     *
     * @maps full_name
     */
    public function setFullName(?string $fullName): void
    {
        $this->fullName = $fullName;
    }

    /**
     * Converts the ShippingName object to a human-readable string representation.
     *
     * @return string The string representation of the ShippingName object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('ShippingName', ['fullName' => $this->fullName]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->fullName)) {
            $json['full_name'] = $this->fullName;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
