<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * An API resource denoting a request to securely store a SEPA Debit.
 */
class SepaDebitRequest implements \JsonSerializable
{
    /**
     * @var SepaDebitExperienceContext|null
     */
    private $experienceContext;

    /**
     * Returns Experience Context.
     * Customizes the payer experience during the approval process for the SEPA Debit payment.
     */
    public function getExperienceContext(): ?SepaDebitExperienceContext
    {
        return $this->experienceContext;
    }

    /**
     * Sets Experience Context.
     * Customizes the payer experience during the approval process for the SEPA Debit payment.
     *
     * @maps experience_context
     */
    public function setExperienceContext(?SepaDebitExperienceContext $experienceContext): void
    {
        $this->experienceContext = $experienceContext;
    }

    /**
     * Converts the SepaDebitRequest object to a human-readable string representation.
     *
     * @return string The string representation of the SepaDebitRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('SepaDebitRequest', ['experienceContext' => $this->experienceContext]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->experienceContext)) {
            $json['experience_context'] = $this->experienceContext;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
