<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Payment Token Request where the `source` defines the type of instrument to be stored.
 */
class PaymentTokenRequest implements \JsonSerializable
{
    /**
     * @var Customer|null
     */
    private $customer;

    /**
     * @var PaymentTokenRequestPaymentSource
     */
    private $paymentSource;

    /**
     * @param PaymentTokenRequestPaymentSource $paymentSource
     */
    public function __construct(PaymentTokenRequestPaymentSource $paymentSource)
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Returns Customer.
     * This object defines a customer in your system. Use it to manage customer profiles, save payment
     * methods and contact details.
     */
    public function getCustomer(): ?Customer
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * This object defines a customer in your system. Use it to manage customer profiles, save payment
     * methods and contact details.
     *
     * @maps customer
     */
    public function setCustomer(?Customer $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Payment Source.
     * The payment method to vault with the instrument details.
     */
    public function getPaymentSource(): PaymentTokenRequestPaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The payment method to vault with the instrument details.
     *
     * @required
     * @maps payment_source
     */
    public function setPaymentSource(PaymentTokenRequestPaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Converts the PaymentTokenRequest object to a human-readable string representation.
     *
     * @return string The string representation of the PaymentTokenRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaymentTokenRequest',
            ['customer' => $this->customer, 'paymentSource' => $this->paymentSource]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->customer)) {
            $json['customer']   = $this->customer;
        }
        $json['payment_source'] = $this->paymentSource;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
