<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The customer and merchant payment preferences.
 */
class PaymentMethod implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $payeePreferred = PayeePaymentMethodPreference::UNRESTRICTED;

    /**
     * Returns Payee Preferred.
     * The merchant-preferred payment methods.
     */
    public function getPayeePreferred(): ?string
    {
        return $this->payeePreferred;
    }

    /**
     * Sets Payee Preferred.
     * The merchant-preferred payment methods.
     *
     * @maps payee_preferred
     */
    public function setPayeePreferred(?string $payeePreferred): void
    {
        $this->payeePreferred = $payeePreferred;
    }

    /**
     * Converts the PaymentMethod object to a human-readable string representation.
     *
     * @return string The string representation of the PaymentMethod object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('PaymentMethod', ['payeePreferred' => $this->payeePreferred]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->payeePreferred)) {
            $json['payee_preferred'] = $this->payeePreferred;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
