<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The details for the failed payment of the subscription.
 */
class FailedPaymentDetails implements \JsonSerializable
{
    /**
     * @var Money
     */
    private $amount;

    /**
     * @var string
     */
    private $time;

    /**
     * @var string|null
     */
    private $reasonCode;

    /**
     * @var string|null
     */
    private $nextPaymentRetryTime;

    /**
     * @param Money $amount
     * @param string $time
     */
    public function __construct(Money $amount, string $time)
    {
        $this->amount = $amount;
        $this->time = $time;
    }

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @required
     * @maps amount
     */
    public function setAmount(Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getTime(): string
    {
        return $this->time;
    }

    /**
     * Sets Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @required
     * @maps time
     */
    public function setTime(string $time): void
    {
        $this->time = $time;
    }

    /**
     * Returns Reason Code.
     * The reason code for the payment failure.
     */
    public function getReasonCode(): ?string
    {
        return $this->reasonCode;
    }

    /**
     * Sets Reason Code.
     * The reason code for the payment failure.
     *
     * @maps reason_code
     */
    public function setReasonCode(?string $reasonCode): void
    {
        $this->reasonCode = $reasonCode;
    }

    /**
     * Returns Next Payment Retry Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getNextPaymentRetryTime(): ?string
    {
        return $this->nextPaymentRetryTime;
    }

    /**
     * Sets Next Payment Retry Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps next_payment_retry_time
     */
    public function setNextPaymentRetryTime(?string $nextPaymentRetryTime): void
    {
        $this->nextPaymentRetryTime = $nextPaymentRetryTime;
    }

    /**
     * Converts the FailedPaymentDetails object to a human-readable string representation.
     *
     * @return string The string representation of the FailedPaymentDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'FailedPaymentDetails',
            [
                'amount' => $this->amount,
                'time' => $this->time,
                'reasonCode' => $this->reasonCode,
                'nextPaymentRetryTime' => $this->nextPaymentRetryTime
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['amount']                      = $this->amount;
        $json['time']                        = $this->time;
        if (isset($this->reasonCode)) {
            $json['reason_code']             = $this->reasonCode;
        }
        if (isset($this->nextPaymentRetryTime)) {
            $json['next_payment_retry_time'] = $this->nextPaymentRetryTime;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
