<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The exchange rate that determines the amount to convert from one currency to another currency.
 */
class ExchangeRate implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $sourceCurrency;

    /**
     * @var string|null
     */
    private $targetCurrency;

    /**
     * @var string|null
     */
    private $value;

    /**
     * Returns Source Currency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that identifies
     * the currency.
     */
    public function getSourceCurrency(): ?string
    {
        return $this->sourceCurrency;
    }

    /**
     * Sets Source Currency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that identifies
     * the currency.
     *
     * @maps source_currency
     */
    public function setSourceCurrency(?string $sourceCurrency): void
    {
        $this->sourceCurrency = $sourceCurrency;
    }

    /**
     * Returns Target Currency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that identifies
     * the currency.
     */
    public function getTargetCurrency(): ?string
    {
        return $this->targetCurrency;
    }

    /**
     * Sets Target Currency.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that identifies
     * the currency.
     *
     * @maps target_currency
     */
    public function setTargetCurrency(?string $targetCurrency): void
    {
        $this->targetCurrency = $targetCurrency;
    }

    /**
     * Returns Value.
     * The target currency amount. Equivalent to one unit of the source currency. Formatted as integer or
     * decimal value with one to 15 digits to the right of the decimal point.
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * Sets Value.
     * The target currency amount. Equivalent to one unit of the source currency. Formatted as integer or
     * decimal value with one to 15 digits to the right of the decimal point.
     *
     * @maps value
     */
    public function setValue(?string $value): void
    {
        $this->value = $value;
    }

    /**
     * Converts the ExchangeRate object to a human-readable string representation.
     *
     * @return string The string representation of the ExchangeRate object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ExchangeRate',
            [
                'sourceCurrency' => $this->sourceCurrency,
                'targetCurrency' => $this->targetCurrency,
                'value' => $this->value
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->sourceCurrency)) {
            $json['source_currency'] = $this->sourceCurrency;
        }
        if (isset($this->targetCurrency)) {
            $json['target_currency'] = $this->targetCurrency;
        }
        if (isset($this->value)) {
            $json['value']           = $this->value;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
