<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The cart information.
 */
class CartInformation implements \JsonSerializable
{
    /**
     * @var ItemDetails[]|null
     */
    private $itemDetails;

    /**
     * @var bool|null
     */
    private $taxInclusive = false;

    /**
     * @var string|null
     */
    private $paypalInvoiceId;

    /**
     * Returns Item Details.
     * An array of item details.
     *
     * @return ItemDetails[]|null
     */
    public function getItemDetails(): ?array
    {
        return $this->itemDetails;
    }

    /**
     * Sets Item Details.
     * An array of item details.
     *
     * @maps item_details
     *
     * @param ItemDetails[]|null $itemDetails
     */
    public function setItemDetails(?array $itemDetails): void
    {
        $this->itemDetails = $itemDetails;
    }

    /**
     * Returns Tax Inclusive.
     * Indicates whether the item amount or the shipping amount already includes tax.
     */
    public function getTaxInclusive(): ?bool
    {
        return $this->taxInclusive;
    }

    /**
     * Sets Tax Inclusive.
     * Indicates whether the item amount or the shipping amount already includes tax.
     *
     * @maps tax_inclusive
     */
    public function setTaxInclusive(?bool $taxInclusive): void
    {
        $this->taxInclusive = $taxInclusive;
    }

    /**
     * Returns Paypal Invoice Id.
     * The ID of the invoice. Appears for only PayPal-generated invoices.
     */
    public function getPaypalInvoiceId(): ?string
    {
        return $this->paypalInvoiceId;
    }

    /**
     * Sets Paypal Invoice Id.
     * The ID of the invoice. Appears for only PayPal-generated invoices.
     *
     * @maps paypal_invoice_id
     */
    public function setPaypalInvoiceId(?string $paypalInvoiceId): void
    {
        $this->paypalInvoiceId = $paypalInvoiceId;
    }

    /**
     * Converts the CartInformation object to a human-readable string representation.
     *
     * @return string The string representation of the CartInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CartInformation',
            [
                'itemDetails' => $this->itemDetails,
                'taxInclusive' => $this->taxInclusive,
                'paypalInvoiceId' => $this->paypalInvoiceId
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->itemDetails)) {
            $json['item_details']      = $this->itemDetails;
        }
        if (isset($this->taxInclusive)) {
            $json['tax_inclusive']     = $this->taxInclusive;
        }
        if (isset($this->paypalInvoiceId)) {
            $json['paypal_invoice_id'] = $this->paypalInvoiceId;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
