<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\VaultCustomer;
use PaypalServerSdkLib\Models\VaultResponse;

/**
 * Builder for model VaultResponse
 *
 * @see VaultResponse
 */
class VaultResponseBuilder
{
    /**
     * @var VaultResponse
     */
    private $instance;

    private function __construct(VaultResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vault Response Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultResponse());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets customer field.
     *
     * @param VaultCustomer|null $value
     */
    public function customer(?VaultCustomer $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Vault Response object.
     */
    public function build(): VaultResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
