<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VaultCardExperienceContext;

/**
 * Builder for model VaultCardExperienceContext
 *
 * @see VaultCardExperienceContext
 */
class VaultCardExperienceContextBuilder
{
    /**
     * @var VaultCardExperienceContext
     */
    private $instance;

    private function __construct(VaultCardExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vault Card Experience Context Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultCardExperienceContext());
    }

    /**
     * Sets brand name field.
     *
     * @param string|null $value
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets locale field.
     *
     * @param string|null $value
     */
    public function locale(?string $value): self
    {
        $this->instance->setLocale($value);
        return $this;
    }

    /**
     * Sets return url field.
     *
     * @param string|null $value
     */
    public function returnUrl(?string $value): self
    {
        $this->instance->setReturnUrl($value);
        return $this;
    }

    /**
     * Sets cancel url field.
     *
     * @param string|null $value
     */
    public function cancelUrl(?string $value): self
    {
        $this->instance->setCancelUrl($value);
        return $this;
    }

    /**
     * Sets vault instruction field.
     *
     * @param string|null $value
     */
    public function vaultInstruction(?string $value): self
    {
        $this->instance->setVaultInstruction($value);
        return $this;
    }

    /**
     * Sets user action field.
     *
     * @param string|null $value
     */
    public function userAction(?string $value): self
    {
        $this->instance->setUserAction($value);
        return $this;
    }

    /**
     * Initializes a new Vault Card Experience Context object.
     */
    public function build(): VaultCardExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
