<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\SubscriptionAmountWithBreakdown;
use PaypalServerSdkLib\Models\SubscriptionPayerName;
use PaypalServerSdkLib\Models\SubscriptionTransactionDetails;

/**
 * Builder for model SubscriptionTransactionDetails
 *
 * @see SubscriptionTransactionDetails
 */
class SubscriptionTransactionDetailsBuilder
{
    /**
     * @var SubscriptionTransactionDetails
     */
    private $instance;

    private function __construct(SubscriptionTransactionDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Transaction Details Builder object.
     *
     * @param string $id
     * @param SubscriptionAmountWithBreakdown $amountWithBreakdown
     * @param string $time
     */
    public static function init(string $id, SubscriptionAmountWithBreakdown $amountWithBreakdown, string $time): self
    {
        return new self(new SubscriptionTransactionDetails($id, $amountWithBreakdown, $time));
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets payer name field.
     *
     * @param SubscriptionPayerName|null $value
     */
    public function payerName(?SubscriptionPayerName $value): self
    {
        $this->instance->setPayerName($value);
        return $this;
    }

    /**
     * Sets payer email field.
     *
     * @param string|null $value
     */
    public function payerEmail(?string $value): self
    {
        $this->instance->setPayerEmail($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Transaction Details object.
     */
    public function build(): SubscriptionTransactionDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
