<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PricingTier;
use PaypalServerSdkLib\Models\SubscriptionPricingScheme;

/**
 * Builder for model SubscriptionPricingScheme
 *
 * @see SubscriptionPricingScheme
 */
class SubscriptionPricingSchemeBuilder
{
    /**
     * @var SubscriptionPricingScheme
     */
    private $instance;

    private function __construct(SubscriptionPricingScheme $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Pricing Scheme Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriptionPricingScheme());
    }

    /**
     * Sets version field.
     *
     * @param int|null $value
     */
    public function version(?int $value): self
    {
        $this->instance->setVersion($value);
        return $this;
    }

    /**
     * Sets fixed price field.
     *
     * @param Money|null $value
     */
    public function fixedPrice(?Money $value): self
    {
        $this->instance->setFixedPrice($value);
        return $this;
    }

    /**
     * Sets pricing model field.
     *
     * @param string|null $value
     */
    public function pricingModel(?string $value): self
    {
        $this->instance->setPricingModel($value);
        return $this;
    }

    /**
     * Sets tiers field.
     *
     * @param PricingTier[]|null $value
     */
    public function tiers(?array $value): self
    {
        $this->instance->setTiers($value);
        return $this;
    }

    /**
     * Sets create time field.
     *
     * @param string|null $value
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     *
     * @param string|null $value
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Pricing Scheme object.
     */
    public function build(): SubscriptionPricingScheme
    {
        return CoreHelper::clone($this->instance);
    }
}
