<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\SubscriptionPayer;

/**
 * Builder for model SubscriptionPayer
 *
 * @see SubscriptionPayer
 */
class SubscriptionPayerBuilder
{
    /**
     * @var SubscriptionPayer
     */
    private $instance;

    private function __construct(SubscriptionPayer $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Payer Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriptionPayer());
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets payer id field.
     *
     * @param string|null $value
     */
    public function payerId(?string $value): self
    {
        $this->instance->setPayerId($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param Name|null $value
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Payer object.
     */
    public function build(): SubscriptionPayer
    {
        return CoreHelper::clone($this->instance);
    }
}
