<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\PhoneWithType;
use PaypalServerSdkLib\Models\ShippingDetails;
use PaypalServerSdkLib\Models\SubscriberRequest;
use PaypalServerSdkLib\Models\SubscriptionPaymentSource;

/**
 * Builder for model SubscriberRequest
 *
 * @see SubscriberRequest
 */
class SubscriberRequestBuilder
{
    /**
     * @var SubscriberRequest
     */
    private $instance;

    private function __construct(SubscriberRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscriber Request Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriberRequest());
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets payer id field.
     *
     * @param string|null $value
     */
    public function payerId(?string $value): self
    {
        $this->instance->setPayerId($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param Name|null $value
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets shipping address field.
     *
     * @param ShippingDetails|null $value
     */
    public function shippingAddress(?ShippingDetails $value): self
    {
        $this->instance->setShippingAddress($value);
        return $this;
    }

    /**
     * Sets payment source field.
     *
     * @param SubscriptionPaymentSource|null $value
     */
    public function paymentSource(?SubscriptionPaymentSource $value): self
    {
        $this->instance->setPaymentSource($value);
        return $this;
    }

    /**
     * Sets phone field.
     *
     * @param PhoneWithType|null $value
     */
    public function phone(?PhoneWithType $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Initializes a new Subscriber Request object.
     */
    public function build(): SubscriberRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
