<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\PhoneNumberWithCountryCode;
use PaypalServerSdkLib\Models\ShippingDetails;
use PaypalServerSdkLib\Models\ShippingName;
use PaypalServerSdkLib\Models\ShippingOption;

/**
 * Builder for model ShippingDetails
 *
 * @see ShippingDetails
 */
class ShippingDetailsBuilder
{
    /**
     * @var ShippingDetails
     */
    private $instance;

    private function __construct(ShippingDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Shipping Details Builder object.
     */
    public static function init(): self
    {
        return new self(new ShippingDetails());
    }

    /**
     * Sets name field.
     *
     * @param ShippingName|null $value
     */
    public function name(?ShippingName $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets phone number field.
     *
     * @param PhoneNumberWithCountryCode|null $value
     */
    public function phoneNumber(?PhoneNumberWithCountryCode $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets options field.
     *
     * @param ShippingOption[]|null $value
     */
    public function options(?array $value): self
    {
        $this->instance->setOptions($value);
        return $this;
    }

    /**
     * Sets address field.
     *
     * @param Address|null $value
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Initializes a new Shipping Details object.
     */
    public function build(): ShippingDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
