<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\SepaDebitExperienceContext;

/**
 * Builder for model SepaDebitExperienceContext
 *
 * @see SepaDebitExperienceContext
 */
class SepaDebitExperienceContextBuilder
{
    /**
     * @var SepaDebitExperienceContext
     */
    private $instance;

    private function __construct(SepaDebitExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Sepa Debit Experience Context Builder object.
     *
     * @param string $returnUrl
     * @param string $cancelUrl
     */
    public static function init(string $returnUrl, string $cancelUrl): self
    {
        return new self(new SepaDebitExperienceContext($returnUrl, $cancelUrl));
    }

    /**
     * Sets locale field.
     *
     * @param string|null $value
     */
    public function locale(?string $value): self
    {
        $this->instance->setLocale($value);
        return $this;
    }

    /**
     * Initializes a new Sepa Debit Experience Context object.
     */
    public function build(): SepaDebitExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
