<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\PaypalWalletCustomer;
use PaypalServerSdkLib\Models\PaypalWalletVaultResponse;

/**
 * Builder for model PaypalWalletVaultResponse
 *
 * @see PaypalWalletVaultResponse
 */
class PaypalWalletVaultResponseBuilder
{
    /**
     * @var PaypalWalletVaultResponse
     */
    private $instance;

    private function __construct(PaypalWalletVaultResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Paypal Wallet Vault Response Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalWalletVaultResponse());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Sets customer field.
     *
     * @param PaypalWalletCustomer|null $value
     */
    public function customer(?PaypalWalletCustomer $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Initializes a new Paypal Wallet Vault Response object.
     */
    public function build(): PaypalWalletVaultResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
