<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaypalWalletStoredCredential;

/**
 * Builder for model PaypalWalletStoredCredential
 *
 * @see PaypalWalletStoredCredential
 */
class PaypalWalletStoredCredentialBuilder
{
    /**
     * @var PaypalWalletStoredCredential
     */
    private $instance;

    private function __construct(PaypalWalletStoredCredential $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Paypal Wallet Stored Credential Builder object.
     *
     * @param string $paymentInitiator
     */
    public static function init(string $paymentInitiator): self
    {
        return new self(new PaypalWalletStoredCredential($paymentInitiator));
    }

    /**
     * Sets charge pattern field.
     *
     * @param string|null $value
     */
    public function chargePattern(?string $value): self
    {
        $this->instance->setChargePattern($value);
        return $this;
    }

    /**
     * Sets usage pattern field.
     *
     * @param string|null $value
     */
    public function usagePattern(?string $value): self
    {
        $this->instance->setUsagePattern($value);
        return $this;
    }

    /**
     * Sets usage field.
     *
     * @param string|null $value
     */
    public function usage(?string $value): self
    {
        $this->instance->setUsage($value);
        return $this;
    }

    /**
     * Initializes a new Paypal Wallet Stored Credential object.
     */
    public function build(): PaypalWalletStoredCredential
    {
        return CoreHelper::clone($this->instance);
    }
}
