<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentMethod;

/**
 * Builder for model PaymentMethod
 *
 * @see PaymentMethod
 */
class PaymentMethodBuilder
{
    /**
     * @var PaymentMethod
     */
    private $instance;

    private function __construct(PaymentMethod $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payment Method Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentMethod());
    }

    /**
     * Sets payee preferred field.
     *
     * @param string|null $value
     */
    public function payeePreferred(?string $value): self
    {
        $this->instance->setPayeePreferred($value);
        return $this;
    }

    /**
     * Initializes a new Payment Method object.
     */
    public function build(): PaymentMethod
    {
        return CoreHelper::clone($this->instance);
    }
}
