<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ExperienceContext;
use PaypalServerSdkLib\Models\MybankPaymentRequest;

/**
 * Builder for model MybankPaymentRequest
 *
 * @see MybankPaymentRequest
 */
class MybankPaymentRequestBuilder
{
    /**
     * @var MybankPaymentRequest
     */
    private $instance;

    private function __construct(MybankPaymentRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Mybank Payment Request Builder object.
     *
     * @param string $name
     * @param string $countryCode
     */
    public static function init(string $name, string $countryCode): self
    {
        return new self(new MybankPaymentRequest($name, $countryCode));
    }

    /**
     * Sets experience context field.
     *
     * @param ExperienceContext|null $value
     */
    public function experienceContext(?ExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new Mybank Payment Request object.
     */
    public function build(): MybankPaymentRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
