<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\IncentiveDetails;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model IncentiveDetails
 *
 * @see IncentiveDetails
 */
class IncentiveDetailsBuilder
{
    /**
     * @var IncentiveDetails
     */
    private $instance;

    private function __construct(IncentiveDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Incentive Details Builder object.
     */
    public static function init(): self
    {
        return new self(new IncentiveDetails());
    }

    /**
     * Sets incentive type field.
     *
     * @param string|null $value
     */
    public function incentiveType(?string $value): self
    {
        $this->instance->setIncentiveType($value);
        return $this;
    }

    /**
     * Sets incentive code field.
     *
     * @param string|null $value
     */
    public function incentiveCode(?string $value): self
    {
        $this->instance->setIncentiveCode($value);
        return $this;
    }

    /**
     * Sets incentive amount field.
     *
     * @param Money|null $value
     */
    public function incentiveAmount(?Money $value): self
    {
        $this->instance->setIncentiveAmount($value);
        return $this;
    }

    /**
     * Sets incentive program code field.
     *
     * @param string|null $value
     */
    public function incentiveProgramCode(?string $value): self
    {
        $this->instance->setIncentiveProgramCode($value);
        return $this;
    }

    /**
     * Initializes a new Incentive Details object.
     */
    public function build(): IncentiveDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
