<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\EpsPaymentObject;

/**
 * Builder for model EpsPaymentObject
 *
 * @see EpsPaymentObject
 */
class EpsPaymentObjectBuilder
{
    /**
     * @var EpsPaymentObject
     */
    private $instance;

    private function __construct(EpsPaymentObject $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Eps Payment Object Builder object.
     */
    public static function init(): self
    {
        return new self(new EpsPaymentObject());
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets country code field.
     *
     * @param string|null $value
     */
    public function countryCode(?string $value): self
    {
        $this->instance->setCountryCode($value);
        return $this;
    }

    /**
     * Sets bic field.
     *
     * @param string|null $value
     */
    public function bic(?string $value): self
    {
        $this->instance->setBic($value);
        return $this;
    }

    /**
     * Initializes a new Eps Payment Object object.
     */
    public function build(): EpsPaymentObject
    {
        return CoreHelper::clone($this->instance);
    }
}
