<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CheckoutOption;

/**
 * Builder for model CheckoutOption
 *
 * @see CheckoutOption
 */
class CheckoutOptionBuilder
{
    /**
     * @var CheckoutOption
     */
    private $instance;

    private function __construct(CheckoutOption $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Checkout Option Builder object.
     */
    public static function init(): self
    {
        return new self(new CheckoutOption());
    }

    /**
     * Sets checkout option name field.
     *
     * @param string|null $value
     */
    public function checkoutOptionName(?string $value): self
    {
        $this->instance->setCheckoutOptionName($value);
        return $this;
    }

    /**
     * Sets checkout option value field.
     *
     * @param string|null $value
     */
    public function checkoutOptionValue(?string $value): self
    {
        $this->instance->setCheckoutOptionValue($value);
        return $this;
    }

    /**
     * Initializes a new Checkout Option object.
     */
    public function build(): CheckoutOption
    {
        return CoreHelper::clone($this->instance);
    }
}
