<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CartInformation;
use PaypalServerSdkLib\Models\ItemDetails;

/**
 * Builder for model CartInformation
 *
 * @see CartInformation
 */
class CartInformationBuilder
{
    /**
     * @var CartInformation
     */
    private $instance;

    private function __construct(CartInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Cart Information Builder object.
     */
    public static function init(): self
    {
        return new self(new CartInformation());
    }

    /**
     * Sets item details field.
     *
     * @param ItemDetails[]|null $value
     */
    public function itemDetails(?array $value): self
    {
        $this->instance->setItemDetails($value);
        return $this;
    }

    /**
     * Sets tax inclusive field.
     *
     * @param bool|null $value
     */
    public function taxInclusive(?bool $value): self
    {
        $this->instance->setTaxInclusive($value);
        return $this;
    }

    /**
     * Sets paypal invoice id field.
     *
     * @param string|null $value
     */
    public function paypalInvoiceId(?string $value): self
    {
        $this->instance->setPaypalInvoiceId($value);
        return $this;
    }

    /**
     * Initializes a new Cart Information object.
     */
    public function build(): CartInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
