<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BalanceInformation;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model BalanceInformation
 *
 * @see BalanceInformation
 */
class BalanceInformationBuilder
{
    /**
     * @var BalanceInformation
     */
    private $instance;

    private function __construct(BalanceInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Balance Information Builder object.
     *
     * @param string $currency
     * @param Money $totalBalance
     */
    public static function init(string $currency, Money $totalBalance): self
    {
        return new self(new BalanceInformation($currency, $totalBalance));
    }

    /**
     * Sets primary field.
     *
     * @param bool|null $value
     */
    public function primary(?bool $value): self
    {
        $this->instance->setPrimary($value);
        return $this;
    }

    /**
     * Sets available balance field.
     *
     * @param Money|null $value
     */
    public function availableBalance(?Money $value): self
    {
        $this->instance->setAvailableBalance($value);
        return $this;
    }

    /**
     * Sets withheld balance field.
     *
     * @param Money|null $value
     */
    public function withheldBalance(?Money $value): self
    {
        $this->instance->setWithheldBalance($value);
        return $this;
    }

    /**
     * Initializes a new Balance Information object.
     */
    public function build(): BalanceInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
