<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AmountBreakdown;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model AmountBreakdown
 *
 * @see AmountBreakdown
 */
class AmountBreakdownBuilder
{
    /**
     * @var AmountBreakdown
     */
    private $instance;

    private function __construct(AmountBreakdown $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Amount Breakdown Builder object.
     */
    public static function init(): self
    {
        return new self(new AmountBreakdown());
    }

    /**
     * Sets item total field.
     *
     * @param Money|null $value
     */
    public function itemTotal(?Money $value): self
    {
        $this->instance->setItemTotal($value);
        return $this;
    }

    /**
     * Sets shipping field.
     *
     * @param Money|null $value
     */
    public function shipping(?Money $value): self
    {
        $this->instance->setShipping($value);
        return $this;
    }

    /**
     * Sets handling field.
     *
     * @param Money|null $value
     */
    public function handling(?Money $value): self
    {
        $this->instance->setHandling($value);
        return $this;
    }

    /**
     * Sets tax total field.
     *
     * @param Money|null $value
     */
    public function taxTotal(?Money $value): self
    {
        $this->instance->setTaxTotal($value);
        return $this;
    }

    /**
     * Sets insurance field.
     *
     * @param Money|null $value
     */
    public function insurance(?Money $value): self
    {
        $this->instance->setInsurance($value);
        return $this;
    }

    /**
     * Sets shipping discount field.
     *
     * @param Money|null $value
     */
    public function shippingDiscount(?Money $value): self
    {
        $this->instance->setShippingDiscount($value);
        return $this;
    }

    /**
     * Sets discount field.
     *
     * @param Money|null $value
     */
    public function discount(?Money $value): self
    {
        $this->instance->setDiscount($value);
        return $this;
    }

    /**
     * Initializes a new Amount Breakdown object.
     */
    public function build(): AmountBreakdown
    {
        return CoreHelper::clone($this->instance);
    }
}
