<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The balances response information.
 */
class BalancesResponse implements \JsonSerializable
{
    /**
     * @var BalanceInformation[]|null
     */
    private $balances;

    /**
     * @var string|null
     */
    private $accountId;

    /**
     * @var string|null
     */
    private $asOfTime;

    /**
     * @var string|null
     */
    private $lastRefreshTime;

    /**
     * Returns Balances.
     * An array of balance detail objects.
     *
     * @return BalanceInformation[]|null
     */
    public function getBalances(): ?array
    {
        return $this->balances;
    }

    /**
     * Sets Balances.
     * An array of balance detail objects.
     *
     * @maps balances
     *
     * @param BalanceInformation[]|null $balances
     */
    public function setBalances(?array $balances): void
    {
        $this->balances = $balances;
    }

    /**
     * Returns Account Id.
     * The PayPal payer ID, which is a masked version of the PayPal account number intended for use with
     * third parties. The account number is reversibly encrypted and a proprietary variant of Base32 is
     * used to encode the result.
     */
    public function getAccountId(): ?string
    {
        return $this->accountId;
    }

    /**
     * Sets Account Id.
     * The PayPal payer ID, which is a masked version of the PayPal account number intended for use with
     * third parties. The account number is reversibly encrypted and a proprietary variant of Base32 is
     * used to encode the result.
     *
     * @maps account_id
     */
    public function setAccountId(?string $accountId): void
    {
        $this->accountId = $accountId;
    }

    /**
     * Returns As of Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getAsOfTime(): ?string
    {
        return $this->asOfTime;
    }

    /**
     * Sets As of Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps as_of_time
     */
    public function setAsOfTime(?string $asOfTime): void
    {
        $this->asOfTime = $asOfTime;
    }

    /**
     * Returns Last Refresh Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getLastRefreshTime(): ?string
    {
        return $this->lastRefreshTime;
    }

    /**
     * Sets Last Refresh Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps last_refresh_time
     */
    public function setLastRefreshTime(?string $lastRefreshTime): void
    {
        $this->lastRefreshTime = $lastRefreshTime;
    }

    /**
     * Converts the BalancesResponse object to a human-readable string representation.
     *
     * @return string The string representation of the BalancesResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BalancesResponse',
            [
                'balances' => $this->balances,
                'accountId' => $this->accountId,
                'asOfTime' => $this->asOfTime,
                'lastRefreshTime' => $this->lastRefreshTime
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->balances)) {
            $json['balances']          = $this->balances;
        }
        if (isset($this->accountId)) {
            $json['account_id']        = $this->accountId;
        }
        if (isset($this->asOfTime)) {
            $json['as_of_time']        = $this->asOfTime;
        }
        if (isset($this->lastRefreshTime)) {
            $json['last_refresh_time'] = $this->lastRefreshTime;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
