<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

/**
 * The status for the authorized payment.
 */
class AuthorizationStatus
{
    /**
     * The authorized payment is created. No captured payments have been made for this authorized payment.
     */
    public const CREATED = 'CREATED';

    /**
     * The authorized payment has one or more captures against it. The sum of these captured payments is
     * greater than the amount of the original authorized payment.
     */
    public const CAPTURED = 'CAPTURED';

    /**
     * PayPal cannot authorize funds for this authorized payment.
     */
    public const DENIED = 'DENIED';

    /**
     * A captured payment was made for the authorized payment for an amount that is less than the amount of
     * the original authorized payment.
     */
    public const PARTIALLY_CAPTURED = 'PARTIALLY_CAPTURED';

    /**
     * The authorized payment was voided. No more captured payments can be made against this authorized
     * payment.
     */
    public const VOIDED = 'VOIDED';

    /**
     * The created authorization is in pending state. For more information, see status.details.
     */
    public const PENDING = 'PENDING';
}
