<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The breakdown of the amount. Breakdown provides details such as total item amount, total tax amount,
 * shipping, handling, insurance, and discounts, if any.
 */
class AmountBreakdown implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $itemTotal;

    /**
     * @var Money|null
     */
    private $shipping;

    /**
     * @var Money|null
     */
    private $handling;

    /**
     * @var Money|null
     */
    private $taxTotal;

    /**
     * @var Money|null
     */
    private $insurance;

    /**
     * @var Money|null
     */
    private $shippingDiscount;

    /**
     * @var Money|null
     */
    private $discount;

    /**
     * Returns Item Total.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getItemTotal(): ?Money
    {
        return $this->itemTotal;
    }

    /**
     * Sets Item Total.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps item_total
     */
    public function setItemTotal(?Money $itemTotal): void
    {
        $this->itemTotal = $itemTotal;
    }

    /**
     * Returns Shipping.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShipping(): ?Money
    {
        return $this->shipping;
    }

    /**
     * Sets Shipping.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping
     */
    public function setShipping(?Money $shipping): void
    {
        $this->shipping = $shipping;
    }

    /**
     * Returns Handling.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getHandling(): ?Money
    {
        return $this->handling;
    }

    /**
     * Sets Handling.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps handling
     */
    public function setHandling(?Money $handling): void
    {
        $this->handling = $handling;
    }

    /**
     * Returns Tax Total.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getTaxTotal(): ?Money
    {
        return $this->taxTotal;
    }

    /**
     * Sets Tax Total.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps tax_total
     */
    public function setTaxTotal(?Money $taxTotal): void
    {
        $this->taxTotal = $taxTotal;
    }

    /**
     * Returns Insurance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getInsurance(): ?Money
    {
        return $this->insurance;
    }

    /**
     * Sets Insurance.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps insurance
     */
    public function setInsurance(?Money $insurance): void
    {
        $this->insurance = $insurance;
    }

    /**
     * Returns Shipping Discount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingDiscount(): ?Money
    {
        return $this->shippingDiscount;
    }

    /**
     * Sets Shipping Discount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_discount
     */
    public function setShippingDiscount(?Money $shippingDiscount): void
    {
        $this->shippingDiscount = $shippingDiscount;
    }

    /**
     * Returns Discount.
     * The discount amount and currency code. For list of supported currencies and decimal precision, see
     * the PayPal REST APIs Currency Codes.
     */
    public function getDiscount(): ?Money
    {
        return $this->discount;
    }

    /**
     * Sets Discount.
     * The discount amount and currency code. For list of supported currencies and decimal precision, see
     * the PayPal REST APIs Currency Codes.
     *
     * @maps discount
     */
    public function setDiscount(?Money $discount): void
    {
        $this->discount = $discount;
    }

    /**
     * Converts the AmountBreakdown object to a human-readable string representation.
     *
     * @return string The string representation of the AmountBreakdown object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'AmountBreakdown',
            [
                'itemTotal' => $this->itemTotal,
                'shipping' => $this->shipping,
                'handling' => $this->handling,
                'taxTotal' => $this->taxTotal,
                'insurance' => $this->insurance,
                'shippingDiscount' => $this->shippingDiscount,
                'discount' => $this->discount
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->itemTotal)) {
            $json['item_total']        = $this->itemTotal;
        }
        if (isset($this->shipping)) {
            $json['shipping']          = $this->shipping;
        }
        if (isset($this->handling)) {
            $json['handling']          = $this->handling;
        }
        if (isset($this->taxTotal)) {
            $json['tax_total']         = $this->taxTotal;
        }
        if (isset($this->insurance)) {
            $json['insurance']         = $this->insurance;
        }
        if (isset($this->shippingDiscount)) {
            $json['shipping_discount'] = $this->shippingDiscount;
        }
        if (isset($this->discount)) {
            $json['discount']          = $this->discount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
