<?php

use App\Models\SuperAdmin;
use App\Models\SubscriptionPlan;

test('super admin can view subscription plans list', function () {
    $superAdmin = SuperAdmin::factory()->create();

    $response = $this->actingAs($superAdmin, 'super_admin')
        ->get(route('super-admin.subscription-plans.index'));

    $response->assertOk();
});

test('super admin can create a subscription plan', function () {
    $superAdmin = SuperAdmin::factory()->create();

    $response = $this->actingAs($superAdmin, 'super_admin')
        ->post(route('super-admin.subscription-plans.store'), [
            'name' => 'Premium Plan',
            'display_name' => 'Premium',
            'description' => 'Premium subscription plan',
            'monthly_price' => 999.00,
            'annual_price' => 9999.00,
            'max_users' => 100,
            'max_units' => 500,
            'max_buildings' => 10,
            'is_active' => true,
            'sort_order' => 1,
        ]);

    $response->assertRedirect(route('super-admin.subscription-plans.index'));
    $this->assertDatabaseHas('subscription_plans', ['name' => 'Premium Plan']);
});

test('super admin can update a subscription plan', function () {
    $superAdmin = SuperAdmin::factory()->create();
    $plan = SubscriptionPlan::factory()->create();

    $response = $this->actingAs($superAdmin, 'super_admin')
        ->put(route('super-admin.subscription-plans.update', $plan), [
            'name' => $plan->name,
            'display_name' => 'Updated Premium',
            'description' => $plan->description,
            'monthly_price' => $plan->monthly_price,
            'annual_price' => $plan->annual_price,
            'max_users' => $plan->max_users,
            'max_units' => $plan->max_units,
            'max_buildings' => $plan->max_buildings,
            'is_active' => $plan->is_active,
            'sort_order' => $plan->sort_order,
        ]);

    $response->assertRedirect(route('super-admin.subscription-plans.index'));
    $this->assertDatabaseHas('subscription_plans', ['id' => $plan->id, 'display_name' => 'Updated Premium']);
});

test('super admin can delete a subscription plan', function () {
    $superAdmin = SuperAdmin::factory()->create();
    $plan = SubscriptionPlan::factory()->create();

    $response = $this->actingAs($superAdmin, 'super_admin')
        ->delete(route('super-admin.subscription-plans.destroy', $plan));

    $response->assertRedirect(route('super-admin.subscription-plans.index'));
    $this->assertDatabaseMissing('subscription_plans', ['id' => $plan->id]);
});
