<?php

use App\Models\Bill;
use App\Models\Expense;
use App\Models\Payment;
use App\Models\Role;
use App\Models\Society;
use App\Models\User;

beforeEach(function () {
    Role::firstOrCreate(['name' => 'society_admin'], ['display_name' => 'Society Admin']);
});

test('society admin can view reports index', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);

    $response = $this->actingAs($admin)
        ->get(route('society.reports.index', $society));

    $response->assertOk();
});

test('society admin can view collection summary report', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);
    Payment::factory()->for($society)->count(5)->create();

    $response = $this->actingAs($admin)
        ->get(route('society.reports.collection-summary', $society));

    $response->assertOk();
});

test('society admin can view arrears report', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);
    Bill::factory()->for($society)->create(['status' => 'overdue']);

    $response = $this->actingAs($admin)
        ->get(route('society.reports.arrears', $society));

    $response->assertOk();
});

test('society admin can view expense breakdown report', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);
    Expense::factory()->for($society)->count(5)->create();

    $response = $this->actingAs($admin)
        ->get(route('society.reports.expense-breakdown', $society));

    $response->assertOk();
});

test('society admin can view financial summary report', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);

    $response = $this->actingAs($admin)
        ->get(route('society.reports.financial-summary', $society));

    $response->assertOk();
});
