<?php

use App\Models\Bill;
use App\Models\Expense;
use App\Models\Payment;
use App\Models\Role;
use App\Models\Society;
use App\Models\User;

beforeEach(function () {
    Role::firstOrCreate(['name' => 'society_admin'], ['display_name' => 'Society Admin']);
});

test('society admin can view dashboard', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);

    $response = $this->actingAs($admin)
        ->get(route('society.dashboard', $society));

    $response->assertOk();
});

test('dashboard shows correct statistics', function () {
    $society = Society::factory()->create();
    $role = Role::where('name', 'society_admin')->first();
    $admin = User::factory()->create(['society_id' => $society->id, 'role_id' => $role->id]);

    // Create some test data
    Bill::factory()->for($society)->count(5)->create();
    Payment::factory()->for($society)->count(3)->create();
    Expense::factory()->for($society)->count(2)->create();

    $response = $this->actingAs($admin)
        ->get(route('society.dashboard', $society));

    $response->assertOk();
    // Dashboard should display statistics
    $response->assertInertia(fn($page) => $page->has('stats'));
});
