<?php

use App\Models\Society;
use App\Models\SubscriptionPlan;
use App\Models\User;

test('authenticated user can view onboarding', function () {
    $user = User::factory()->create();

    $response = $this->actingAs($user)
        ->get(route('dashboard'));

    $response->assertOk();
});

test('user can create society during onboarding', function () {
    $user = User::factory()->create();
    $plan = SubscriptionPlan::factory()->create(['is_active' => true]);

    $response = $this->actingAs($user)
        ->post(route('onboarding.society.store'), [
            'name' => 'New Society',
            'registration_no' => 'REG123',
            'address' => '123 Test St',
            'city' => 'Test City',
            'state' => 'Test State',
            'pincode' => '123456',
            'phone' => '1234567890',
            'email' => 'society@test.com',
            'subscription_plan_id' => $plan->id,
        ]);

    $response->assertRedirect();
    $this->assertDatabaseHas('societies', ['name' => 'New Society']);
});

test('user cannot create society without subscription plan', function () {
    $user = User::factory()->create();

    $response = $this->actingAs($user)
        ->post(route('onboarding.society.store'), [
            'name' => 'New Society',
            'registration_no' => 'REG123',
            'address' => '123 Test St',
            'city' => 'Test City',
            'state' => 'Test State',
            'pincode' => '123456',
            'phone' => '1234567890',
            'email' => 'society@test.com',
        ]);

    $response->assertSessionHasErrors();
});
