<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

test('installation welcome page can be accessed', function () {
    $response = $this->get(route('install.welcome'));

    $response->assertOk();
});

test('installation requirements page can be accessed', function () {
    $response = $this->get(route('install.requirements'));

    $response->assertOk();
});

test('installation database page can be accessed', function () {
    $response = $this->get(route('install.database'));

    $response->assertOk();
});

test('installation admin page can be accessed', function () {
    $response = $this->get(route('install.admin'));

    $response->assertOk();
});

test('installation can check requirements', function () {
    $response = $this->post(route('install.requirements'));

    $response->assertOk();
    $response->assertJsonStructure(['php_version', 'extensions', 'permissions']);
});

test('installation can configure database', function () {
    $response = $this->post(route('install.database'), [
        'host' => env('DB_HOST', '127.0.0.1'),
        'port' => env('DB_PORT', '3306'),
        'database' => env('DB_DATABASE', 'testing'),
        'username' => env('DB_USERNAME', 'root'),
        'password' => env('DB_PASSWORD', ''),
    ]);

    $response->assertOk();
});

test('installation can create admin user', function () {
    // This test would need the database to be set up first
    // Skipping actual database creation in test environment
    $response = $this->post(route('install.admin'), [
        'name' => 'Super Admin',
        'email' => 'admin@example.com',
        'password' => 'password123',
        'password_confirmation' => 'password123',
    ]);

    // The response depends on whether installation is already complete
    $response->assertStatus(200);
});
