<?php

use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\Route;

test('role middleware allows user with correct role on web routes', function () {
    $role = Role::firstOrCreate(
        ['name' => 'society_admin'],
        ['display_name' => 'Society Admin']
    );
    $user = User::factory()->create([
        'role_id' => $role->id,
        'phone' => '9990000001',
    ]);

    Route::middleware(['web', 'role:society_admin'])->get('/test/admin-only', function () {
        return 'ok';
    });

    $this->actingAs($user)
        ->get('/test/admin-only')
        ->assertOk();
});

test('role middleware blocks user with incorrect role on web routes', function () {
    $adminRole = Role::firstOrCreate(
        ['name' => 'society_admin'],
        ['display_name' => 'Society Admin']
    );
    $residentRole = Role::firstOrCreate(
        ['name' => 'resident'],
        ['display_name' => 'Resident']
    );

    $resident = User::factory()->create([
        'role_id' => $residentRole->id,
        'phone' => '9990000002',
    ]);

    Route::middleware(['web', 'role:society_admin'])->get('/test/admin-only-block', function () {
        return 'ok';
    });

    $this->actingAs($resident)
        ->get('/test/admin-only-block')
        ->assertForbidden();
});
