<?php

use App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController;
use App\Http\Controllers\SuperAdmin\DashboardController;
use App\Http\Controllers\SuperAdmin\SocietyController;
use App\Http\Controllers\SuperAdmin\SubscriptionPlanController;
use App\Http\Controllers\SuperAdmin\UserController;
use App\Http\Controllers\SuperAdmin\SystemSettingController;
use Illuminate\Support\Facades\Route;

// Public routes
Route::middleware('guest:super_admin')->prefix('super-admin')->name('super-admin.')->group(function () {
    Route::get('/login', [AuthenticatedSessionController::class, 'create'])->name('login');
    Route::post('/login', [AuthenticatedSessionController::class, 'store']);
});

// Protected routes
Route::middleware(['auth:super_admin'])->prefix('super-admin')->name('super-admin.')->group(function () {
    Route::post('/logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::resource('societies', SocietyController::class);
    Route::resource('users', UserController::class);
    Route::resource('subscription-plans', SubscriptionPlanController::class);
    
    // System Settings
    Route::get('/settings', [SystemSettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SystemSettingController::class, 'update'])->name('settings.update');
    Route::post('/settings/upload', [SystemSettingController::class, 'upload'])->name('settings.upload');
    
    // Firebase Settings
    Route::post('/settings/firebase/upload', [SystemSettingController::class, 'uploadFirebaseCredentials'])->name('settings.firebase.upload');
    Route::delete('/settings/firebase/remove', [SystemSettingController::class, 'removeFirebaseCredentials'])->name('settings.firebase.remove');
    // CMS Management
    Route::resource('cms/features', \App\Http\Controllers\SuperAdmin\CmsFeatureController::class)->names('cms.features');
    Route::resource('cms/faqs', \App\Http\Controllers\SuperAdmin\CmsFaqController::class)->names('cms.faqs');
    Route::resource('cms/testimonials', \App\Http\Controllers\SuperAdmin\CmsTestimonialController::class)->names('cms.testimonials');
});
