<?php

use App\Http\Controllers\SubAdmin\DashboardController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'verified', 'role:sub_admin'])->group(function () {
    Route::prefix('societies/{society}/sub-admin')->middleware('society.access')->name('sub-admin.')->group(function () {
        // Dashboard
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // Note: Other routes (residents, units, bills, etc.) will reuse Society Admin controllers
        // but with permission checks to limit access
    });
});
