<?php

use App\Http\Controllers\SocietyAdmin\AnnouncementController;
use App\Http\Controllers\SocietyAdmin\AdminAdController;
use App\Http\Controllers\SocietyAdmin\AdminAdSettingsController;
use App\Http\Controllers\SocietyAdmin\BankAccountController;
use App\Http\Controllers\SocietyAdmin\BillController;
use App\Http\Controllers\SocietyAdmin\BillCycleController;
use App\Http\Controllers\SocietyAdmin\BuildingController;
use App\Http\Controllers\SocietyAdmin\CollectorWalletController;
use App\Http\Controllers\SocietyAdmin\DashboardController;
use App\Http\Controllers\SocietyAdmin\DirectoryController;
use App\Http\Controllers\SocietyAdmin\CommunityPostController;
use App\Http\Controllers\SocietyAdmin\ExpenseController;
use App\Http\Controllers\SocietyAdmin\FacilityController;
use App\Http\Controllers\SocietyAdmin\MaintenanceController;
use App\Http\Controllers\SocietyAdmin\MaintenanceStructureController;
use App\Http\Controllers\SocietyAdmin\PaymentController;
use App\Http\Controllers\SocietyAdmin\ReportController;
use App\Http\Controllers\SocietyAdmin\ResidentController;
use App\Http\Controllers\SocietyAdmin\RevenueController;
use App\Http\Controllers\SocietyAdmin\SettingsController;
use App\Http\Controllers\SocietyAdmin\TeamController;
use App\Http\Controllers\SocietyAdmin\UnitController;
use App\Http\Controllers\SocietyAdmin\VisitorController;
use Illuminate\Support\Facades\Route;

// Shared routes for society_admin, sub_admin, and accountant roles
// Each role has different access levels
Route::middleware(['auth', 'verified', 'role:society_admin,sub_admin,accountant'])->group(function () {
    Route::prefix('societies/{society}')->middleware(['society.access', 'check.overdue'])->name('society.')->group(function () {
        
        // Dashboard - Society Admin only (sub_admin and accountant have their own dashboards)
        Route::get('/dashboard', [DashboardController::class, 'index'])
            ->middleware('role:society_admin')
            ->name('dashboard');

        // ========== MANAGEMENT ROUTES (Society Admin & Sub Admin only) ==========
        Route::middleware('role:society_admin,sub_admin')->group(function () {
            // Residents
            Route::resource('residents', ResidentController::class);

            // Buildings
            Route::resource('buildings', BuildingController::class);

            // Units
            Route::resource('units', UnitController::class);

            // Maintenance Tickets
            Route::resource('maintenance', MaintenanceController::class)->except(['edit', 'update', 'destroy']);
            Route::post('maintenance/{maintenanceTicket}/update-status', [MaintenanceController::class, 'updateStatus'])->name('maintenance.update-status');
            Route::post('maintenance/{maintenanceTicket}/assign-vendor', [MaintenanceController::class, 'assignVendor'])->name('maintenance.assign-vendor');
            Route::post('maintenance/{maintenanceTicket}/resolve', [MaintenanceController::class, 'resolve'])->name('maintenance.resolve');

            // Visitors
            Route::resource('visitors', VisitorController::class)->except(['edit', 'update', 'destroy']);
            Route::post('visitors/{visitor}/check-in', [VisitorController::class, 'checkIn'])->name('visitors.check-in');
            Route::post('visitors/{visitor}/check-out', [VisitorController::class, 'checkOut'])->name('visitors.check-out');
            Route::post('visitors/{visitor}/approve', [VisitorController::class, 'approve'])->name('visitors.approve');
            Route::post('visitors/{visitor}/reject', [VisitorController::class, 'reject'])->name('visitors.reject');

            // Announcements
            Route::resource('announcements', AnnouncementController::class)->except(['show']);
            Route::post('announcements/{announcement}/toggle-publish', [AnnouncementController::class, 'togglePublish'])->name('announcements.toggle-publish');

            // Community Management
            Route::resource('community', CommunityPostController::class)->only(['index', 'destroy']);
        });

        // ========== EMERGENCY ROUTES (All management roles) ==========
        // JSON routes for real-time SOS alert polling in web admin
        Route::get('/emergency/active', [\App\Http\Controllers\Api\EmergencyController::class, 'active'])
            ->name('emergency.active');
        Route::post('/emergency/{id}/resolve', [\App\Http\Controllers\Api\EmergencyController::class, 'resolve'])
            ->name('emergency.resolve');

        // ========== FINANCE ROUTES (All roles: Society Admin, Sub Admin, Accountant) ==========
        
        // Bill Cycles
        Route::resource('bill-cycles', BillCycleController::class)->except(['show', 'edit', 'update', 'destroy']);
        Route::post('bill-cycles/{billCycle}/generate', [BillCycleController::class, 'generateBills'])->name('bill-cycles.generate');
        Route::post('bill-cycles/{billCycle}/post', [BillCycleController::class, 'postBills'])->name('bill-cycles.post');

        // Maintenance Structures
        Route::resource('maintenance-structures', MaintenanceStructureController::class);

        // Bills
        Route::resource('bills', BillController::class)->except(['edit', 'destroy']);
        Route::post('bills/{bill}/revise', [BillController::class, 'revise'])->name('bills.revise');
        Route::post('bills/approve', [BillController::class, 'approve'])->name('bills.approve');

        // Payments
        Route::post('payments/generate-qr', [PaymentController::class, 'generateQRCode'])->name('payments.generate-qr');
        Route::post('payments/send-request', [PaymentController::class, 'sendPaymentRequest'])->name('payments.send-request');
        Route::get('payments/check-status/{linkId}', [PaymentController::class, 'checkPaymentStatus'])->name('payments.check-status');
        Route::get('payments/due-bills/{resident}', [PaymentController::class, 'getDueBills'])->name('payments.due-bills');
        Route::post('payments/{payment}/reconcile', [PaymentController::class, 'reconcile'])->name('payments.reconcile');
        Route::resource('payments', PaymentController::class)->except(['edit', 'destroy']);

        // Bank Accounts
        Route::resource('bank-accounts', BankAccountController::class)->except(['show', 'destroy']);
        Route::post('bank-accounts/{bankAccount}/update-balance', [BankAccountController::class, 'updateBalance'])->name('bank-accounts.update-balance');
        Route::get('bank-accounts/{bankAccount}/transactions', [BankAccountController::class, 'transactions'])->name('bank-accounts.transactions');
        Route::get('bank-accounts/{bankAccount}/export', [BankAccountController::class, 'export'])->name('bank-accounts.export');
        Route::post('bank-accounts/{bankAccount}/reconcile', [BankAccountController::class, 'reconcile'])->name('bank-accounts.reconcile');

        // Expenses
        Route::resource('expenses', ExpenseController::class);

        // Reports
        Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
        Route::get('/reports/collection-summary', [ReportController::class, 'collectionSummary'])->name('reports.collection-summary');
        Route::get('/reports/arrears', [ReportController::class, 'arrears'])->name('reports.arrears');
        Route::get('/reports/expense-breakdown', [ReportController::class, 'expenseBreakdown'])->name('reports.expense-breakdown');
        Route::get('/reports/expense-breakdown', [ReportController::class, 'expenseBreakdown'])->name('reports.expense-breakdown');
        Route::get('/reports/financial-summary', [ReportController::class, 'financialSummary'])->name('reports.financial-summary');

        // Revenue Dashboard
        Route::get('/revenue', [RevenueController::class, 'index'])->name('revenue.index');
        Route::get('/revenue/history', [RevenueController::class, 'history'])->name('revenue.history');

        // ========== ADMIN ONLY ROUTES (Society Admin only) ==========
        Route::middleware('role:society_admin')->group(function () {
            // Team Management
            Route::resource('team', TeamController::class)->except(['show', 'create', 'edit']);

            // Settings
            Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
            Route::put('/settings', [SettingsController::class, 'update'])->name('settings.update');

            // Ads & Monetization
            // Ads & Monetization
            Route::get('monetization/requests', [AdminAdController::class, 'requests'])->name('monetization.requests');
            Route::post('monetization/{advertisement}/approve', [AdminAdController::class, 'approve'])->name('monetization.approve');
            Route::post('monetization/{advertisement}/reject', [AdminAdController::class, 'reject'])->name('monetization.reject');
            
            Route::get('monetization/settings', [AdminAdSettingsController::class, 'index'])->name('monetization.settings');
            Route::post('monetization/settings', [AdminAdSettingsController::class, 'update'])->name('monetization.settings.update');

            Route::resource('monetization', AdminAdController::class)->only(['index', 'destroy', 'show']);

            // Facilities Management (Admin only can manage facilities and slots)
            Route::resource('facilities', FacilityController::class);
            Route::post('facilities/{facility}/slots', [FacilityController::class, 'manageSlots'])->name('facilities.manage-slots');
            Route::delete('facilities/{facility}/slots/{slot}', [FacilityController::class, 'deleteSlot'])->name('facilities.delete-slot');
            
            // Facility Bookings Management (Admin can view all bookings and update status)
            Route::get('facility-bookings', [FacilityController::class, 'allBookings'])->name('facility-bookings.index');
            Route::get('facility-bookings/{booking}', [FacilityController::class, 'showBooking'])->name('facility-bookings.show');
            Route::post('facility-bookings/{booking}/status', [FacilityController::class, 'updateBookingStatus'])->name('facility-bookings.update-status');

            // Collector Wallet Management
            Route::get('collectors/wallets', [CollectorWalletController::class, 'index'])->name('collectors.wallets');
            Route::get('collectors/{collector}/wallet', [CollectorWalletController::class, 'show'])->name('collectors.wallet.show');
            Route::post('collectors/{collector}/handover', [CollectorWalletController::class, 'recordHandover'])->name('collectors.handover');
        });

        // Directory (permission based)
        Route::get('/directory', [DirectoryController::class, 'index'])
            ->middleware('permission:directory.view')
            ->name('directory.index');
    });
});
