<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// Schedule the overdue check command daily
\Illuminate\Support\Facades\Schedule::command('app:check-overdue-bills')->daily();

// Schedule subscription expiry check daily at 9am
\Illuminate\Support\Facades\Schedule::command('subscriptions:check-expiry')->dailyAt('09:00');

// Clear password reset tokens daily
\Illuminate\Support\Facades\Schedule::command('auth:clear-resets')->daily();

// Auto-generate billing cycles on the 1st of every month at 2:00 AM
\Illuminate\Support\Facades\Schedule::command('billing:auto-generate-cycle')
    ->monthlyOn(1, '02:00')
    ->timezone('Asia/Kolkata');

// Test push notification command
Artisan::command('test:push {user_id}', function ($user_id) {
    $user = \App\Models\User::find($user_id);
    
    if (!$user) {
        $this->error("User with ID {$user_id} not found.");
        return 1;
    }
    
    if (!$user->fcm_token) {
        $this->error("User '{$user->name}' has no FCM token registered.");
        return 1;
    }
    
    $this->info("Sending test notification to: {$user->name} ({$user->email})");
    $this->info("FCM Token: " . substr($user->fcm_token, 0, 30) . '...');
    
    $firebaseService = app(\App\Services\FirebaseNotificationService::class);
    
    $result = $firebaseService->sendToUser(
        $user,
        'Test Notification',
        'This is a test push notification from Societify',
        ['type' => 'announcement', 'id' => '1']
    );
    
    if ($result) {
        $this->info('✅ Notification sent successfully!');
        return 0;
    } else {
        $this->error('❌ Failed to send notification. Check storage/logs/laravel.log for details.');
        return 1;
    }
})->purpose('Send a test push notification to a user');
