<?php

use App\Http\Controllers\Accountant\DashboardController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'verified', 'role:accountant'])->group(function () {
    Route::prefix('societies/{society}/accountant')->middleware('society.access')->name('accountant.')->group(function () {
        // Dashboard
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // Note: Other routes (bills, payments, bank-accounts, expenses, reports) reuse Society Admin controllers
        // Accountant has full access to financial modules
    });
});
