@component('mail::message')
# Payment Received 💰

Dear **{{ $society->name }}** Team,

We have received your payment successfully. Thank you!

## Payment Details

@component('mail::panel')
| | |
|---|---|
| **Amount** | ₹{{ number_format($payment->amount, 2) }} |
| **Currency** | {{ $payment->currency }} |
| **Payment ID** | {{ $payment->razorpay_payment_id ?? $payment->id }} |
| **Date** | {{ $payment->paid_at?->format('d M, Y H:i') ?? now()->format('d M, Y H:i') }} |
| **Status** | Completed ✓ |
@endcomponent

## Subscription Status

| | |
|---|---|
| **Plan** | {{ $subscription->plan_display_name ?? $subscription->plan_name }} |
| **Valid Until** | {{ $subscription->end_date?->format('d M, Y') }} |

This email serves as your payment receipt.

Thanks,<br>
The {{ $appName }} Team
@endcomponent
