@component('mail::message')
# ⚠️ Your Subscription Expires Soon

Dear **{{ $society->name }}** Team,

Your subscription is expiring in **{{ $daysRemaining }} {{ $daysRemaining === 1 ? 'day' : 'days' }}**.

## Current Subscription

@component('mail::panel')
| | |
|---|---|
| **Plan** | {{ $subscription->plan_display_name ?? $subscription->plan_name }} |
| **Expires On** | {{ $subscription->end_date?->format('d M, Y') }} |
@endcomponent

To avoid service interruption, please renew your subscription before the expiry date.

@component('mail::button', ['url' => $renewUrl, 'color' => 'primary'])
Renew Now
@endcomponent

## What Happens After Expiry?

- Your society access will be limited
- Residents won't be able to access the app
- No new bills or payments can be processed

Don't wait until the last moment - renew today!

Thanks,<br>
The {{ $appName }} Team
@endcomponent
